<?php
$pageTitle = 'Buat Tiket Baru';
if (!Auth::isLoggedIn()) { redirect(base_url('login')); }
?>
<main class="flex-1 overflow-x-hidden overflow-y-auto p-6 md:p-8">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-semibold text-gray-700 flex items-center">
            <i class="fas fa-plus-circle mr-3 text-green-500"></i> Buat Tiket Baru
        </h2>
        <a href="<?php echo base_url('tickets'); ?>" class="text-sm text-blue-600 hover:underline">&larr; Kembali ke Daftar Tiket</a>
    </div>

    <div id="create-ticket-message" class="mb-4 text-sm"></div>

    <div class="bg-white p-6 rounded-xl shadow-lg border border-gray-100">
        <form id="create-ticket-form" action="<?php echo base_url('ajax/create_ticket'); ?>" method="POST">
            <div class="space-y-4">
                <div>
                    <label for="subject" class="block text-sm font-medium text-gray-700 mb-1">Subjek <span class="text-red-500">*</span></label>
                    <input type="text" id="subject" name="subject" required maxlength="255"
                           placeholder="Contoh: Masalah Deposit QRIS"
                           class="input-field w-full px-4 py-2 text-sm border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                    <span id="subject-error" class="text-xs text-red-500 mt-1 block"></span>
                </div>

                <div>
                    <label for="message" class="block text-sm font-medium text-gray-700 mb-1">Pesan <span class="text-red-500">*</span></label>
                    <textarea id="message" name="message" rows="6" required
                              placeholder="Jelaskan masalah atau pertanyaan Anda di sini..."
                              class="input-field w-full px-4 py-2 text-sm border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500"></textarea>
                    <span id="message-error" class="text-xs text-red-500 mt-1 block"></span>
                </div>

                <div>
                    <label for="attachment" class="block text-sm font-medium text-gray-700 mb-1">Lampiran (Opsional)</label>
                    <input type="file" id="attachment" name="attachment" accept="image/jpeg, image/png, image/gif, image/webp"
                           class="input-field block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 cursor-pointer border border-gray-300 rounded-lg p-1 focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                    <span id="attachment-error" class="text-xs text-red-500 mt-1 block"></span>
                    <p class="text-xs text-gray-400 mt-1">Format: JPG, PNG, GIF, WEBP. Maks: 2MB.</p>
                </div>
                <div class="pt-4 flex justify-end">
                    <button type="submit" id="submit-ticket"
                            class="px-6 py-2.5 text-sm font-semibold text-white bg-green-600 rounded-lg shadow-md hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 transition duration-150 ease-in-out">
                        <span id="ticket-btn-text">Kirim Tiket</span>
                        <i id="ticket-spinner" class="fas fa-spinner fa-spin ml-2 hidden"></i>
                    </button>
                </div>
            </div>
        </form>
    </div>
</main>
