<?php

$pageTitle = 'Buat Pesanan Baru';

if (!Auth::isLoggedIn()) { redirect(base_url('login')); }

?>
<main class="flex-1 overflow-x-hidden overflow-y-auto p-6 md:p-8">
    <h2 class="text-2xl font-semibold text-gray-700 mb-6">Pesanan Baru</h2>

    <div class="mb-6">
        <h3 class="text-lg font-medium text-gray-600 mb-3">Filter Kategori</h3>
        <div id="category-filter-buttons" class="flex flex-wrap gap-2">
            <button data-category-id="all" class="category-filter-btn active px-4 py-1.5 text-sm font-medium bg-blue-600 text-white rounded-full shadow hover:bg-blue-700 transition">
                Semua
            </button>
            <span id="category-filter-loading" class="text-sm text-gray-500 hidden">Memuat kategori...</span>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <div class="lg:col-span-2 bg-white p-6 rounded-xl shadow-lg border border-gray-100">
            <h3 class="text-xl font-semibold text-gray-800 mb-5 border-b pb-3">Formulir Pesanan</h3>

            <div id="order-message" class="mb-4 text-sm"></div>

            <form id="order-form" method="POST" class="space-y-5">
                <div>
                    <label for="category" class="block text-sm font-medium text-gray-700 mb-1">Kategori <span class="text-red-500">*</span></label>
                    <select id="category" name="category" required
                            class="input-field block w-full px-4 py-2.5 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm transition duration-150 ease-in-out">
                        <option value="" disabled selected>-- Pilih Kategori --</option>
                        </select>
                    <span id="category-error" class="text-red-500 text-xs mt-1"></span>
                </div>

                <div>
                    <label for="service" class="block text-sm font-medium text-gray-700 mb-1">Layanan <span class="text-red-500">*</span></label>
                    <select id="service" name="service" required disabled
                            class="input-field block w-full px-4 py-2.5 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm transition duration-150 ease-in-out bg-gray-100 disabled:opacity-70">
                        <option value="" disabled selected>-- Pilih Kategori Dahulu --</option>
                        </select>
                     <span id="service-error" class="text-red-500 text-xs mt-1"></span>
                </div>

                <div id="service-details-container" class="hidden mt-4">
                    <label class="block text-sm font-medium text-gray-700 mb-1">Deskripsi & Catatan</label>
                    <div id="service-notes" class="text-sm p-3 bg-blue-50 border border-blue-200 rounded-lg text-gray-700 min-h-[50px]">
                        Pilih layanan untuk melihat catatan.
                    </div>
                 </div>

                 <div>
                    <label for="target" class="block text-sm font-medium text-gray-700 mb-1">Target <span class="text-red-500">*</span></label>
                    <input id="target" name="target" type="text" required placeholder="Masukkan link atau username target"
                           class="input-field appearance-none block w-full px-4 py-2.5 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm transition duration-150 ease-in-out" />
                    <span id="target-error" class="text-red-500 text-xs mt-1"></span>
                </div>

                 <div>
                    <label for="quantity" class="block text-sm font-medium text-gray-700 mb-1">Jumlah Pesanan <span class="text-red-500">*</span></label>
                    <input id="quantity" name="quantity" type="number" required placeholder="Masukkan jumlah" disabled
                           class="input-field appearance-none block w-full px-4 py-2.5 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm transition duration-150 ease-in-out bg-gray-100 disabled:opacity-70" />
                    <div id="min-max-info" class="text-xs text-gray-500 mt-1">
                        </div>
                     <span id="quantity-error" class="text-red-500 text-xs mt-1"></span>
                </div>

                <div class="mt-4 pt-4 border-t">
                     <label class="block text-sm font-medium text-gray-700 mb-1">Total Harga</label>
                     <div id="total-price" class="text-xl font-semibold text-blue-600">
                         Rp 0
                     </div>
                      <p class="text-xs text-gray-500 mt-1">Harga per 1000: <span id="price-per-1000">Rp 0</span></p>
                </div>

                <div class="pt-5">
                    <button type="submit" id="order-button" disabled
                            class="w-full flex justify-center py-3 px-4 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition duration-150 ease-in-out disabled:opacity-50 disabled:cursor-not-allowed">
                        <i class="fas fa-paper-plane mr-2 mt-0.5"></i> <span id="order-button-text">Buat Pesanan</span>
                        <i id="order-spinner" class="fas fa-spinner fa-spin ml-2 hidden"></i>
                    </button>
                </div>

            </form>
        </div>

        <div class="lg:col-span-1 bg-white p-6 rounded-xl shadow-lg border border-gray-100 h-fit"> <?php /* h-fit agar tingginya sesuai konten */ ?>
            <h3 class="text-xl font-semibold text-gray-800 mb-4 flex items-center">
                <i class="fas fa-info-circle text-blue-500 mr-2"></i> Informasi
            </h3>
            <div class="space-y-3 text-sm text-gray-600">
                <h4 class="font-medium text-gray-800">Rules Pemesanan:</h4>
                <ul class="list-disc list-inside space-y-1 pl-2 text-xs">
                    <li>Pastikan Anda menginput data yang benar sesuai format pada kolom deskripsi, karena kami tidak bisa membatalkan pesanan.</li>
                    <li>Jangan menggabungkan lebih dari satu layanan sekaligus untuk data/target yang sama.</li>
                    <li>Harap tunggu status Success pada pesanan sebelumnya baru melakukan pesanan kepada data/target yang sama.</li>
                    <li>Seluruh pesanan Server 1, jika akun target yang diinput kamu kunci (menjadi private), pesanan akan otomatis menjadi Success dan tidak ada pengembalian dana.</li>
                    <li>Jika status pesanan Error & Partial, saldo Anda akan otomatis dikembalikan.</li>
                    <li>Jumlah Maksimal Pesanan menunjukkan kapasitas layanan tersebut untuk satu target, bukan menunjukkan kapasitas sekali pemesanan.</li>
                    <li>Dengan melakukan pemesanan, Anda dianggap sudah memahami dan menyetujui Syarat & Ketentuan.</li>
                </ul>
                 <h4 class="font-medium text-gray-800 pt-3 border-t mt-4">Penting!</h4>
                 <p class="text-xs">Jika Anda mendapat pesan gagal saat melakukan pemesanan, silakan informasikan layanan tersebut melalui Tiket atau hubungi Admin.</p>
            </div>
        </div>
    </div>

</main>
