<?php

$pageTitle = $pageTitle ?? 'Otentikasi';
$appName = htmlspecialchars($appSettings['app_name'] ?? 'SMM Panel');
$baseUrlPhp = defined('BASE_URL') ? rtrim(BASE_URL, '/') : null;

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($pageTitle) . ' - ' . htmlspecialchars($appName); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <?php if ($baseUrlPhp):  ?>
        <link rel="stylesheet" href="<?php echo htmlspecialchars($baseUrlPhp . '/assets/css/style.css'); ?>">
        <link rel="stylesheet" href="<?php echo htmlspecialchars($baseUrlPhp . '/assets/css/auth.css'); ?>">
    <?php else: ?>
        <style> body { background-color: #f00; color: #fff; padding: 20px; } </style>
    <?php endif; ?>
    <style>
        body { font-family: 'Poppins', sans-serif; }
    </style>

    <script>
        <?php if ($baseUrlPhp): ?>
            const BASE_URL = "<?php echo $baseUrlPhp; ?>";
        <?php else: ?>
            const BASE_URL = "<?php echo $baseUrlPhp ?: ''; ?>";
        <?php endif; ?>
    </script>
    </head>
<body class="bg-gradient-to-br from-blue-700 via-indigo-800 to-indigo-900">

    <?php
    if (isset($contentView) && file_exists($contentView)) {
        include $contentView;
    } else {
        echo "<p class='text-center text-red-500 mt-10'>Error: Content view file not found.</p>";
    }
    ?>

    <?php if ($baseUrlPhp): ?>
        <script src="<?php echo htmlspecialchars($baseUrlPhp . '/assets/js/auth.js'); ?>"></script>
    <?php endif; ?>
    </body>
</html>
