<?php
$isImpersonating = isset($_SESSION['is_impersonating']) && $_SESSION['is_impersonating'] === true;
$originalAdminUsername = $_SESSION['original_admin_username'] ?? 'Admin';
global $appSettings, $pageTitle;
    $finalPageTitle = ($pageTitle ?? '') . ' - ' . ($appSettings['app_name'] ?? 'SMM Panel');
    ?>
    <!DOCTYPE html>
    <html lang="id">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title><?php echo htmlspecialchars($finalPageTitle); ?></title>
        <script src="https://cdn.tailwindcss.com"></script>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/choices.js/public/assets/styles/choices.min.css"/>
        <link rel="stylesheet" href="<?php echo base_url('assets/css/style.css'); ?>">
        <link rel="stylesheet" href="<?php echo base_url('assets/css/admin.css'); ?>">
        <script>
            const BASE_URL = '<?php echo rtrim(BASE_URL, '/'); ?>';
            const APP_NAME_JS = '<?php echo htmlspecialchars($appSettings['app_name'] ?? 'SMM Panel', ENT_QUOTES, 'UTF-8'); ?>';
        </script>
        <style>
            body {
                font-family: 'Inter', 'Poppins', sans-serif;
            }
            .choices__inner { background-color: #fff; border: 1px solid #d1d5db; min-height: 38px; }
            .choices__list--dropdown .choices__item--selectable.is-highlighted { background-color: #3b82f6; }
            .submenu { max-height: 0; overflow: hidden; transition: max-height 0.3s ease-out; }
            .submenu.open { max-height: 500px;  }
            .submenu li a { 
                display: block; 
                padding: 8px 16px 8px 44px; 
                font-size: 0.875rem; 
                color: #d1d5db; 
                transition: background-color 0.2s; 
                border-radius: 0.375rem; 
                margin-left: 0.5rem; 
                margin-right: 0.5rem; 
            }

            .submenu li a:hover { 
                background-color: rgba(255, 255, 255, 0.1); 
                color: #fff; 
            }
            .sidebar-link.active { background-color: rgba(255, 255, 255, 0.15); color: #fff; font-weight: 600; }
            #sidebar { transition: transform 0.3s ease-in-out; }
            #sidebar.open { transform: translateX(0); }
            @media (max-width: 1023px) { #sidebar { transform: translateX(-100%); } }
            #sidebar-overlay { position: fixed; inset: 0; background-color: black; opacity: 0; transition: opacity 0.3s ease-in-out; z-index: 35; pointer-events: none; }
        </style>
    </head>
    <body class="bg-gray-100 flex">
        
        <?php include TEMPLATE_DIR . '/partials/sidebar.php'; ?>

        <div class="flex-1 flex flex-col overflow-hidden">
            <?php include TEMPLATE_DIR . '/partials/header.php'; ?>

             <?php if ($isImpersonating): ?>
            <div class="bg-yellow-500 text-black text-sm font-semibold shadow-md z-40 sticky top-0">
                <div class="max-w-full mx-auto px-4 sm:px-6 lg:px-8 py-2">
                     <div class="flex flex-col sm:flex-row justify-between items-center gap-2 text-center sm:text-left">
                        <span class="flex-grow mb-1 sm:mb-0">
                            <i class="fas fa-user-secret mr-2"></i> Anda sedang login sebagai <strong class="underline"><?php echo htmlspecialchars($_SESSION['username']); ?></strong>.
                        </span>
                        <a href="<?php echo base_url('return_to_admin'); ?>" class="flex-shrink-0 px-3 py-1 bg-gray-800 text-white rounded hover:bg-gray-700 transition text-xs font-bold whitespace-nowrap">
                            <i class="fas fa-sign-out-alt mr-1"></i> Kembali ke Akun Admin (<?php echo htmlspecialchars($originalAdminUsername); ?>)
                        </a>
                    </div>
                </div>
            </div>
            <?php endif; ?>


            <?php if (isset($contentView) && file_exists($contentView)): ?>
                <?php require_once $contentView; ?>
            <?php else: ?>
                <main class="flex-1 overflow-x-hidden overflow-y-auto p-6">
                    <h2 class="text-2xl font-semibold text-gray-700">Error</h2>
                    <p class="text-red-500 mt-4">Konten halaman tidak ditemukan.</p>
                </main>
            <?php endif; ?>
        </div>
         <div id="sidebar-overlay" class="fixed inset-0 bg-black opacity-0 pointer-events-none transition-opacity duration-300 z-30 lg:hidden"></div>
    </div>

    <div id="chat-widget-container">
        <button id="chat-widget-toggle" aria-label="Buka Chat" title="Buka Chat Bantuan">
            <div class="chat-icon-wrapper">
                <i id="chat-widget-icon" class="fas fa-comments"></i>
                <i id="chat-widget-close-icon" class="fas fa-times"></i>
            </div>
        </button>

        <div id="chat-widget-window" class="hidden">
            <div id="chat-widget-header">
                <div class="flex items-center space-x-2.5">
                    <div class="avatar-icon">
                        <i class="fas fa-robot"></i>
                    </div>
                    <div>
                        <h3 class="agent-name">Asisten Virtual</h3>
                        <p class="agent-status">Online</p>
                    </div>
                </div>
                <button id="chat-widget-close-header" aria-label="Tutup Chat">
                    <i class="fas fa-times"></i>
                </button>
            </div>

            <div id="chat-widget-messages">
                </div>

            <div id="chat-widget-input-area">
                <div id="chat-widget-options">
                    </div>
                <div id="chat-widget-text-input" class="hidden">
                    <input type="text" id="chat-user-input" placeholder="Ketik pesan Anda di sini...">
                    <button id="chat-send-button" aria-label="Kirim Pesan" disabled>
                        <i class="fas fa-paper-plane"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>


<style>
    #chat-widget-container {
            position: fixed;
            bottom: 1.5rem; 
            right: 1.5rem; 
            z-index: 1000;
        }

        #chat-widget-toggle {
            background-image: linear-gradient(135deg, #6366F1 , #8B5CF6 );
            color: white;
            width: 3.75rem; 
            height: 3.75rem; 
            border-radius: 9999px; 
            box-shadow: 0 10px 20px -5px rgba(99, 102, 241, 0.4), 0 6px 10px -7px rgba(139, 92, 246, 0.3);
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: transform 0.25s cubic-bezier(0.34, 1.56, 0.64, 1), box-shadow 0.25s ease-out;
            border: none;
        }
        #chat-widget-toggle:hover {
            transform: scale(1.1) rotate(5deg);
            box-shadow: 0 15px 25px -5px rgba(99, 102, 241, 0.5), 0 8px 15px -7px rgba(139, 92, 246, 0.4);
        }
        #chat-widget-toggle:focus {
            outline: none;
            box-shadow: 0 0 0 4px rgba(129, 140, 248, 0.5); 
        }
        #chat-widget-toggle .chat-icon-wrapper {
            position: relative;
            width: 1.75rem; 
            height: 1.75rem;
        }
        #chat-widget-toggle .fas {
            font-size: 1.5rem; 
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            transition: opacity 0.2s ease-out, transform 0.3s cubic-bezier(0.34, 1.56, 0.64, 1);
        }
        #chat-widget-toggle .fa-times {
            opacity: 0;
            transform: translate(-50%, -50%) rotate(-90deg) scale(0.5);
        }
        #chat-widget-toggle.open .fa-comments {
            opacity: 0;
            transform: translate(-50%, -50%) rotate(90deg) scale(0.5);
        }
        #chat-widget-toggle.open .fa-times {
            opacity: 1;
            transform: translate(-50%, -50%) rotate(0deg) scale(1);
        }

        #chat-widget-window {
            position: absolute;
            bottom: calc(100% + 1rem); 
            right: 0;
            width: 24rem; 
            max-width: calc(100vw - 3rem);
            background-color: #ffffff;
            border-radius: 1rem; 
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
            border: 1px solid #f3f4f6; 
            overflow: hidden;
            display: flex;
            flex-direction: column;
            max-height: min(650px, 85vh);
            transition: opacity 0.3s cubic-bezier(0.4, 0, 0.2, 1), transform 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            transform-origin: bottom right;
        }
        #chat-widget-window.hidden {
            opacity: 0;
            transform: scale(0.9) translateY(20px);
            pointer-events: none;
        }

        #chat-widget-header {
            background-color: #fff;
            padding: 1rem 1.25rem; 
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-shrink: 0;
            border-bottom: 1px solid #f3f4f6; 
        }
        #chat-widget-header .avatar-icon {
            background-image: linear-gradient(135deg, #4f46e5, #8B5CF6);
            padding: 0.5rem; 
            border-radius: 0.625rem; 
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            width: 2.5rem; 
            height: 2.5rem; 
            box-shadow: 0 4px 6px -1px rgba(99, 102, 241, 0.2), 0 2px 4px -1px rgba(139, 92, 246, 0.1);
        }
        #chat-widget-header .avatar-icon .fa-robot {
            font-size: 1.125rem; 
        }
        #chat-widget-header .agent-name {
            font-weight: 600; 
            font-size: 1rem; 
            color: #111827; 
        }
        #chat-widget-header .agent-status {
            font-size: 0.75rem; 
            color: #16a34a; 
            font-weight: 500;
        }
        #chat-widget-close-header {
            color: #9ca3af; 
            background-color: transparent;
            border: none;
            padding: 0.375rem; 
            border-radius: 0.5rem; 
            cursor: pointer;
            transition: color 0.2s ease, background-color 0.2s ease;
        }
        #chat-widget-close-header:hover {
            color: #1f2937; 
            background-color: #f3f4f6; 
        }
        #chat-widget-close-header .fa-times {
            font-size: 1.125rem; 
        }

        #chat-widget-messages {
            flex-grow: 1;
            padding: 1.25rem; 
            overflow-y: auto;
            background-color: #f9fafb; 
            scrollbar-width: thin;
            scrollbar-color: #d1d5db #f9fafb;
        }
        #chat-widget-messages::-webkit-scrollbar { width: 8px; }
        #chat-widget-messages::-webkit-scrollbar-track { background: #f9fafb; }
        #chat-widget-messages::-webkit-scrollbar-thumb { background-color: #d1d5db; border-radius: 10px; border: 2px solid #f9fafb; }
        #chat-widget-messages::-webkit-scrollbar-thumb:hover { background-color: #9ca3af; }

        .chat-message { display: flex; margin-bottom: 1rem;  }
        .chat-message.user { justify-content: flex-end; }
        .chat-message.bot { justify-content: flex-start; align-items: flex-end;  }

        .chat-bubble {
            padding: 0.75rem 1rem; 
            border-radius: 1rem; 
            max-width: 80%;
            box-shadow: 0 4px 10px -2px rgba(0, 0, 0, 0.05);
            word-wrap: break-word;
            font-size: 0.875rem; 
            line-height: 1.6;
        }
        .chat-bubble.user {
            background-image: linear-gradient(135deg, #4f46e5, #8B5CF6);
            color: white;
            border-bottom-right-radius: 0.25rem; 
        }
        .chat-bubble.bot {
            background-color: #ffffff;
            color: #374151; 
            border: 1px solid #e5e7eb; 
            border-bottom-left-radius: 0.25rem; 
        }
        .bot-avatar {
            flex-shrink: 0;
            width: 2.25rem; 
            height: 2.25rem; 
            border-radius: 9999px;
            background-image: linear-gradient(135deg, #6366F1, #8B5CF6);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            box-shadow: 0 2px 4px rgba(99, 102, 241, 0.2);
            margin-right: 0.625rem; 
        }
        .bot-avatar .fa-robot { font-size: 1rem; }
        .chat-bubble p { margin-bottom: 0.5rem; }
        .chat-bubble p:last-child { margin-bottom: 0; }
        .chat-bubble ul { list-style-type: disc; padding-left: 1.25rem; margin-top: 0.5rem; margin-bottom: 0.5rem; }
        .chat-bubble li { margin-bottom: 0.25rem; }
        .chat-bubble strong { font-weight: 600; color: inherit; } 
        .chat-bubble.user strong { color: #e0e7ff; } 
        .chat-bubble.bot strong { color: #374151; } 
        .chat-bubble em { font-style: italic; }

        .typing-indicator-wrapper { align-items: flex-end; }
        .typing-indicator { display: flex; align-items: center; padding: 0.75rem 1rem; }
        .typing-indicator span { height: 8px; width: 8px; margin: 0 2.5px; background-color: #9ca3af; border-radius: 50%; opacity: 0.4; animation: typing-blink 1.4s infinite both; }
        .typing-indicator span:nth-child(1) { animation-delay: 0.2s; }
        .typing-indicator span:nth-child(2) { animation-delay: 0.4s; }
        .typing-indicator span:nth-child(3) { animation-delay: 0.6s; }
        @keyframes typing-blink { 0% { opacity: 0.2; } 20% { opacity: 1; } 100% { opacity: 0.2; } }

        #chat-widget-input-area {
            padding: 1rem; 
            border-top: 1px solid #f3f4f6; 
            background-color: #ffffff;
            flex-shrink: 0;
        }
        #chat-widget-options { display: flex; flex-direction: column; gap: 0.625rem;  }
        #chat-widget-options .option-title { font-size: 0.875rem;  color: #4b5563;  margin-bottom: 0.75rem;  padding-left: 0.25rem; font-weight: 500; }
        #chat-widget-options button {
            width: 100%;
            padding: 0.75rem 1rem; 
            font-size: 0.875rem; 
            font-weight: 500; 
            border-radius: 0.625rem; 
            border: 1px solid #e5e7eb; 
            text-align: left;
            transition: background-color 0.2s ease-in-out, border-color 0.2s ease-in-out, color 0.2s ease-in-out;
            color: #374151; 
            background-color: #f9fafb; 
        }
        #chat-widget-options button:hover {
            background-color: #f3f4f6; 
            border-color: #d1d5db; 
            color: #1f2937; 
        }
        #chat-widget-options button.primary-option {
            background-color: #eef2ff; 
            border-color: #c7d2fe; 
            color: #4338ca; 
        }
        #chat-widget-options button.primary-option:hover {
            background-color: #e0e7ff; 
            border-color: #a5b4fc; 
        }
        #chat-widget-options button:focus { outline: none; box-shadow: 0 0 0 3px rgba(165, 180, 252, 0.5);  }


        #chat-widget-text-input { position: relative; display: flex; align-items: center; }
        #chat-user-input {
            flex-grow: 1;
            padding-left: 1rem;
            padding-right: 3.5rem; 
            height: 3rem; 
            font-size: 0.875rem;
            border: 1px solid #e5e7eb; 
            border-radius: 0.75rem; 
            box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.03);
            transition: border-color 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
            background-color: #f9fafb; 
        }
        #chat-user-input::placeholder { color: #9ca3af; }
        #chat-user-input:focus {
            outline: none;
            border-color: #818cf8; 
            background-color: #fff;
            box-shadow: 0 0 0 3px rgba(199, 210, 254, 0.5); 
        }
        #chat-send-button {
            position: absolute;
            right: 0.375rem; 
            top: 50%;
            transform: translateY(-50%);
            width: 2.25rem; 
            height: 2.25rem; 
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            background-image: linear-gradient(135deg, #6366F1, #8B5CF6);
            border-radius: 0.625rem; 
            transition: background-color 0.2s ease-in-out, transform 0.1s ease-out;
            border: none;
        }
        #chat-send-button:hover { background-image: linear-gradient(135deg, #4f46e5, #7c3aed); }
        #chat-send-button:focus { outline: none; box-shadow: 0 0 0 3px rgba(165, 180, 252, 0.5); }
        #chat-send-button:active { transform: translateY(-50%) scale(0.92); }
        #chat-send-button:disabled { opacity: 0.6; cursor: not-allowed; background-image: linear-gradient(135deg, #a5b4fc, #c4b5fd); }
        #chat-send-button .fa-paper-plane { font-size: 0.875rem; }

        .end-chat-input-btn {
            width: 100%;
            margin-top: 0.75rem; 
            padding: 0.625rem 1rem; 
            font-size: 0.875rem;
            font-weight: 500;
            border-radius: 0.625rem; 
            border: 1px solid #e5e7eb;
            color: #4b5563;
            background-color: #f3f4f6;
            transition: background-color 0.2s ease-in-out;
        }
        .end-chat-input-btn:hover { background-color: #e5e7eb; }
        .end-chat-input-btn:focus { outline: none; box-shadow: 0 0 0 2px rgba(209, 213, 219, 0.5); }
        .end-chat-input-btn i { margin-right: 0.5rem; }
</style>
        <div id="login-information-modal" class="fixed inset-0 z-[70] hidden items-center justify-center bg-black bg-opacity-75 transition-opacity duration-300 ease-in-out p-4" aria-labelledby="login-information-modal-title" role="dialog" aria-modal="true">
        <div class="relative bg-gray-800 rounded-xl shadow-2xl w-full max-w-2xl mx-auto transform transition-all duration-300 ease-in-out scale-95 opacity-0 flex flex-col max-h-[90vh]" id="login-information-modal-content">
            <div class="flex items-center justify-between px-6 py-4 border-b border-gray-700 flex-shrink-0">
                <h3 class="text-xl font-semibold text-gray-100 flex items-center" id="login-information-modal-title">
                    <i class="fas fa-bullhorn mr-3 text-yellow-400"></i> Informasi Penting
                </h3>
                <button type="button" id="close-login-information-modal-header" class="text-gray-400 hover:text-white focus:outline-none">
                    <span class="sr-only">Tutup</span><i class="fas fa-times text-xl"></i>
                </button>
            </div>
            <div class="p-6 space-y-4 text-sm overflow-y-auto flex-grow text-gray-300" id="login-information-modal-body">
                <div class="flex justify-center items-center h-48">
                    <i class="fas fa-spinner fa-spin text-3xl text-gray-400"></i>
                </div>
            </div>
            <div class="px-6 py-4 bg-gray-750 border-t border-gray-700 rounded-b-xl flex justify-end flex-shrink-0">
                <button type="button" id="mark-info-as-read-button" class="px-6 py-2.5 text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 rounded-lg shadow-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-blue-500 transition">
                    <i class="fas fa-check-circle mr-2"></i> Saya Sudah Membaca
                </button>
            </div>
        </div>
    </div>
    
    <script>
        const currentLoggedInUserId = <?php echo isset($_SESSION['user_id']) ? json_encode($_SESSION['user_id']) : 'null'; ?>;
    </script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js@3.7.1/dist/chart.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chartjs-adapter-date-fns@2.0.0/dist/chartjs-adapter-date-fns.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/choices.js@9.0.1/public/assets/scripts/choices.min.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/choices.js@9.0.1/public/assets/styles/choices.min.css"/>

    <script src="<?php echo base_url('assets/js/script.js'); ?>"></script>
    <script src="<?php echo base_url('assets/js/admin.js'); ?>"></script>
</body>
</html>