<?php
    $pageTitle = 'Pengaturan Website';
    if (!Auth::isLoggedIn() || $_SESSION['user_role'] !== 'admin') { redirect(base_url('login')); }

    $currentSettings = [
        'app_name' => '', 
        'meta_description' => '',
        'app_logo' => '', 
        'meta_keywords' => '',
        'contact_email' => '',
        'contact_phone' => '',
    ];

    ?>
    <main class="flex-1 overflow-x-hidden overflow-y-auto p-6 md:p-8">
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-2xl font-semibold text-gray-700 flex items-center">
                <i class="fas fa-cog mr-3 text-gray-500"></i> Pengaturan Website
            </h2>
        </div>

        <div id="website-settings-message" class="mb-4 text-sm"></div>

        <div class="bg-white p-6 rounded-xl shadow-lg border border-gray-100">
            <form id="website-settings-form" action="<?php echo base_url('ajax/admin/update_website_settings'); ?>" method="POST" enctype="multipart/form-data">
                <div class="space-y-6">

                    <fieldset class="border border-gray-200 p-4 rounded-lg">
                        <legend class="text-sm font-medium text-gray-600 px-2">Informasi Dasar</legend>
                        <div class="mt-4 space-y-4">
                            <div>
                                <label for="setting_app_name" class="block text-sm font-medium text-gray-700 mb-1">Nama Aplikasi <span class="text-red-500">*</span></label>
                                <input type="text" id="setting_app_name" name="app_name" required maxlength="50"
                                       placeholder="Nama Website Anda"
                                       class="input-field w-full px-4 py-2 text-sm border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <span id="setting_app_name-error" class="text-xs text-red-500 mt-1 block"></span>
                            </div>
                             <div>
                                <label for="setting_app_logo" class="block text-sm font-medium text-gray-700 mb-1">Logo Aplikasi (Opsional)</label>
                                <input type="file" id="setting_app_logo" name="app_logo" accept="image/png, image/jpeg, image/gif, image/svg+xml"
                                       class="input-field block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 cursor-pointer border border-gray-300 rounded-lg p-1 focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <span id="setting_app_logo-error" class="text-xs text-red-500 mt-1 block"></span>
                                <div id="logo-preview-container" class="mt-2 hidden">
                                    <p class="text-xs text-gray-500 mb-1">Preview Logo Saat Ini:</p>
                                    <img id="logo-preview" src="#" alt="Preview Logo" class="max-h-16 w-auto rounded border bg-gray-100 p-1">
                                    <button type="button" id="remove-logo-btn" class="mt-1 text-xs text-red-600 hover:underline">Hapus Logo Saat Ini</button>
                                    <input type="hidden" name="remove_logo" id="remove_logo_flag" value="0">
                                </div>
                                <p class="text-xs text-gray-400 mt-1">Format: PNG, JPG, GIF, SVG. Rekomendasi rasio 1:1 atau landscape. Maks 1MB.</p>
                            </div>
                        </div>
                    </fieldset>

                     <fieldset class="border border-gray-200 p-4 rounded-lg">
                        <legend class="text-sm font-medium text-gray-600 px-2">SEO & Metadata</legend>
                         <div class="mt-4 space-y-4">
                            <div>
                                <label for="setting_meta_description" class="block text-sm font-medium text-gray-700 mb-1">Deskripsi Meta</label>
                                <textarea id="setting_meta_description" name="meta_description" rows="3" maxlength="160"
                                          placeholder="Deskripsi singkat website untuk mesin pencari (maks 160 karakter)"
                                          class="input-field w-full px-4 py-2 text-sm border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500"></textarea>
                                <span id="setting_meta_description-error" class="text-xs text-red-500 mt-1 block"></span>
                            </div>
                             <div>
                                <label for="setting_meta_keywords" class="block text-sm font-medium text-gray-700 mb-1">Kata Kunci Meta</label>
                                <input type="text" id="setting_meta_keywords" name="meta_keywords"
                                       placeholder="Contoh: smm panel, panel sosial media, followers murah (pisahkan dengan koma)"
                                       class="input-field w-full px-4 py-2 text-sm border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <span id="setting_meta_keywords-error" class="text-xs text-red-500 mt-1 block"></span>
                            </div>
                        </div>
                    </fieldset>

                     <fieldset class="border border-gray-200 p-4 rounded-lg">
                        <legend class="text-sm font-medium text-gray-600 px-2">Informasi Kontak</legend>
                         <div class="mt-4 space-y-4">
                            <div>
                                <label for="setting_contact_email" class="block text-sm font-medium text-gray-700 mb-1">Email Kontak</label>
                                <input type="email" id="setting_contact_email" name="contact_email"
                                       placeholder="Alamat email untuk dihubungi"
                                       class="input-field w-full px-4 py-2 text-sm border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <span id="setting_contact_email-error" class="text-xs text-red-500 mt-1 block"></span>
                            </div>
                             <div>
                                <label for="setting_contact_phone" class="block text-sm font-medium text-gray-700 mb-1">Nomor Telepon/WA Kontak</label>
                                <input type="tel" id="setting_contact_phone" name="contact_phone"
                                       placeholder="Nomor telepon atau WhatsApp"
                                       class="input-field w-full px-4 py-2 text-sm border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <span id="setting_contact_phone-error" class="text-xs text-red-500 mt-1 block"></span>
                            </div>
                        </div>
                    </fieldset>

                    <div class="pt-5 flex justify-end">
                        <button type="submit" id="save-settings-button"
                                class="px-6 py-2.5 text-sm font-semibold text-white bg-blue-600 rounded-lg shadow-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-150 ease-in-out">
                            <span id="settings-btn-text">Simpan Pengaturan</span>
                            <i id="settings-spinner" class="fas fa-spinner fa-spin ml-2 hidden"></i>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </main>
    