<?php
$pageTitle = 'Kelola Pengguna';

$initialStatusFilter = $_GET['status'] ?? 'all';
$initialRoleFilter = $_GET['role'] ?? 'all';
$initialSearchQuery = $_GET['search'] ?? '';
$initialLimit = $_GET['limit'] ?? 15;

$statusOptionsAdmin = [
    'all' => 'Semua Status',
    'active' => 'Aktif',
    'inactive' => 'Nonaktif',
    'banned' => 'Diblokir'
];
$roleOptionsAdmin = [
    'all' => 'Semua Peran',
    'member' => 'Member',
    'admin' => 'Admin',
];
$searchColumnOptionsAdmin = [
    'u.id' => 'ID User',
    'u.username' => 'Username',
    'u.email' => 'Email',
    'u.full_name' => 'Nama Lengkap',
    'u.phone_number' => 'No. HP'
];
$sortColumnOptionsAdmin = [
    'u.created_at' => 'Tgl Daftar',
    'u.id' => 'ID User',
    'u.username' => 'Username',
    'u.email' => 'Email',
    'u.full_name' => 'Nama',
    'u.balance' => 'Saldo',
    'u.role' => 'Peran',
    'u.status' => 'Status'
];
$sortTypeOptionsAdmin = ['DESC' => 'Terbaru/Tertinggi', 'ASC' => 'Terlama/Terendah'];

?>
<main class="flex-1 overflow-x-hidden overflow-y-auto p-6 md:p-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
        <h2 class="text-2xl font-semibold text-gray-700 flex items-center">
            <i class="fas fa-users-cog mr-3 text-purple-500"></i> Kelola Pengguna
        </h2>
        <div class="flex items-center space-x-2">
             <button type="button" id="admin-user-filter-modal-button"
                    class="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg shadow-sm hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition">
                <i class="fas fa-filter mr-1"></i> Filter & Cari
            </button>
            <button type="button" id="add-user-button"
               class="px-4 py-2 text-sm font-medium text-white bg-green-600 rounded-lg shadow hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 transition">
                <i class="fas fa-user-plus mr-1"></i> Tambah Pengguna
            </button>
        </div>
    </div>

    <div id="admin-users-message" class="mb-4 text-sm"></div>

    <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Username</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nama</th>
                        <th scope="col" class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Saldo</th>
                        <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Peran</th>
                        <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tgl Daftar</th>
                        <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                    </tr>
                </thead>
                <tbody id="admin-users-table-body" class="bg-white divide-y divide-gray-200">
                    <tr>
                        <td colspan="9" class="px-6 py-10 text-center text-sm text-gray-500 italic">
                            <i class="fas fa-spinner fa-spin mr-2"></i> Memuat data pengguna...
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
         <div id="admin-users-pagination-container" class="px-4 py-3 border-t border-gray-200 bg-gray-50 text-xs text-gray-600 flex flex-col sm:flex-row justify-between items-center">
            <div id="admin-users-pagination-info">Menampilkan 0 hasil.</div>
            <div id="admin-users-pagination-controls" class="flex justify-end mt-2 sm:mt-0 space-x-1"></div>
        </div>
    </div>

    <div id="admin-user-filter-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-60 transition-opacity duration-300 ease-in-out" aria-labelledby="admin-user-filter-modal-title" role="dialog" aria-modal="true">
        <div class="relative bg-gray-800 rounded-lg shadow-xl w-full max-w-2xl mx-4 transform transition-all duration-300 ease-in-out scale-95 opacity-0" id="admin-user-filter-modal-content">
            <div class="flex items-center justify-between px-6 py-4 border-b border-gray-700">
                <h3 class="text-lg font-semibold text-gray-100 flex items-center" id="admin-user-filter-modal-title">
                    <i class="fas fa-filter mr-2 text-blue-400"></i> Filter Pengguna
                </h3>
                <button type="button" id="close-admin-user-filter-modal" class="text-gray-400 hover:text-white focus:outline-none">
                    <span class="sr-only">Tutup</span><i class="fas fa-times text-xl"></i>
                </button>
            </div>
            <form id="admin-user-filter-form" class="p-6 space-y-4">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <label for="filter_limit_admin" class="block text-sm font-medium text-gray-300 mb-1">Tampilkan</label>
                        <select id="filter_limit_admin" name="limit" class="admin-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <option value="15" <?php echo ($initialLimit == 15) ? 'selected' : ''; ?>>15 baris</option>
                            <option value="30" <?php echo ($initialLimit == 30) ? 'selected' : ''; ?>>30 baris</option>
                            <option value="50" <?php echo ($initialLimit == 50) ? 'selected' : ''; ?>>50 baris</option>
                            <option value="100" <?php echo ($initialLimit == 100) ? 'selected' : ''; ?>>100 baris</option>
                        </select>
                    </div>
                    <div>
                        <label for="filter_status_admin" class="block text-sm font-medium text-gray-300 mb-1">Status</label>
                        <select id="filter_status_admin" name="status" class="admin-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <?php foreach ($statusOptionsAdmin as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($initialStatusFilter === $value) ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="filter_role_admin" class="block text-sm font-medium text-gray-300 mb-1">Peran</label>
                        <select id="filter_role_admin" name="role" class="admin-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                             <?php foreach ($roleOptionsAdmin as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($initialRoleFilter === $value) ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="filter_search_column_admin" class="block text-sm font-medium text-gray-300 mb-1">Kolom Cari</label>
                        <select id="filter_search_column_admin" name="search_column" class="admin-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                             <?php foreach ($searchColumnOptionsAdmin as $value => $label): ?>
                                <option value="<?php echo $value; ?>"><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="filter_search_keyword_admin" class="block text-sm font-medium text-gray-300 mb-1">Kata Kunci</label>
                        <input type="text" id="filter_search_keyword_admin" name="search_keyword" value="<?php echo htmlspecialchars($initialSearchQuery); ?>" placeholder="Masukkan kata kunci..."
                               class="admin-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                 </div>
                 <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="filter_sort_by_admin" class="block text-sm font-medium text-gray-300 mb-1">Urutkan</label>
                        <select id="filter_sort_by_admin" name="sort_by" class="admin-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <?php foreach ($sortColumnOptionsAdmin as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($value === 'u.created_at') ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="filter_sort_type_admin" class="block text-sm font-medium text-gray-300 mb-1">Tipe</label>
                        <select id="filter_sort_type_admin" name="sort_type" class="admin-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                             <?php foreach ($sortTypeOptionsAdmin as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($value === 'DESC') ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                 <div class="flex justify-end items-center pt-4 space-x-3 border-t border-gray-700 mt-5">
                     <button type="button" id="reset-admin-user-filter-button" class="px-4 py-2 text-sm font-medium text-gray-300 bg-gray-600 rounded-lg hover:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-gray-500 transition">Reset</button>
                     <button type="submit" id="apply-admin-user-filter-button" class="px-5 py-2 text-sm font-medium text-white bg-blue-600 rounded-lg shadow hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-blue-500 transition"><i class="fas fa-filter mr-1"></i> Terapkan</button>
                 </div>
            </form>
        </div>
    </div>

    <div id="edit-user-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-60 transition-opacity duration-300 ease-in-out p-4" aria-labelledby="edit-user-modal-title" role="dialog" aria-modal="true">
        <div class="relative bg-white rounded-xl shadow-xl w-full max-w-xl transform transition-all duration-300 ease-in-out scale-95 opacity-0 flex flex-col max-h-[90vh]" id="edit-user-modal-content">
            <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t flex-shrink-0">
                <h3 id="edit-user-modal-title" class="text-xl font-semibold text-gray-900 flex items-center">
                    <i class="fas fa-user-edit mr-3 text-blue-500"></i> Edit Pengguna
                </h3>
                <button type="button" id="close-edit-user-modal" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center">
                    <i class="fas fa-times text-xl"></i>
                    <span class="sr-only">Tutup modal</span>
                </button>
            </div>
            <div class="p-4 md:p-5 space-y-4 overflow-y-auto flex-grow">
                <form id="edit-user-form" class="space-y-4">
                    <p class="text-center text-gray-500 italic py-5">Memuat form edit pengguna...</p>
                </form>
                 <div id="edit-user-message" class="text-sm mt-4"></div>
            </div>
            <div class="flex items-center justify-end p-4 md:p-5 space-x-3 rtl:space-x-reverse border-t border-gray-200 rounded-b flex-shrink-0">
                <button id="cancel-edit-user-button" type="button" class="py-2.5 px-5 text-sm font-medium text-gray-900 focus:outline-none bg-white rounded-lg border border-gray-200 hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-4 focus:ring-gray-100">Batal</button>
                <button id="save-edit-user-button" type="submit" form="edit-user-form" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center">
                    Simpan Perubahan
                </button>
            </div>
        </div>
    </div>
    <div id="add-user-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-60 transition-opacity duration-300 ease-in-out" aria-labelledby="add-user-modal-title" role="dialog" aria-modal="true">
         <div class="relative bg-white rounded-lg shadow-xl w-full max-w-lg mx-4 transform transition-all duration-300 ease-in-out scale-95 opacity-0" id="add-user-modal-content">
             <div class="flex items-center justify-between p-5 border-b rounded-t">
                 <h3 id="add-user-modal-title" class="text-xl font-semibold text-gray-900 flex items-center">
                     <i class="fas fa-user-plus mr-3 text-green-500"></i> Tambah Pengguna Baru
                 </h3>
                 <button type="button" id="close-add-user-modal" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center">
                     <i class="fas fa-times text-xl"></i><span class="sr-only">Tutup</span>
                 </button>
             </div>
             <form id="add-user-form" class="p-6 space-y-4">
                 <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                     <div>
                         <label for="add_username" class="block text-sm font-medium text-gray-700 mb-1">Username <span class="text-red-500">*</span></label>
                         <input type="text" id="add_username" name="username" required class="input-field w-full px-3 py-2 border border-gray-300 rounded-lg sm:text-sm focus:ring-blue-500 focus:border-blue-500">
                         <span id="add_username-error" class="text-red-500 text-xs mt-1"></span>
                     </div>
                     <div>
                         <label for="add_email" class="block text-sm font-medium text-gray-700 mb-1">Email <span class="text-red-500">*</span></label>
                         <input type="email" id="add_email" name="email" required class="input-field w-full px-3 py-2 border border-gray-300 rounded-lg sm:text-sm focus:ring-blue-500 focus:border-blue-500">
                         <span id="add_email-error" class="text-red-500 text-xs mt-1"></span>
                     </div>
                 </div>
                 <div>
                     <label for="add_full_name" class="block text-sm font-medium text-gray-700 mb-1">Nama Lengkap</label>
                     <input type="text" id="add_full_name" name="full_name" class="input-field w-full px-3 py-2 border border-gray-300 rounded-lg sm:text-sm focus:ring-blue-500 focus:border-blue-500">
                     <span id="add_full_name-error" class="text-red-500 text-xs mt-1"></span>
                 </div>
                 <div>
                     <label for="add_phone_number" class="block text-sm font-medium text-gray-700 mb-1">Nomor HP</label>
                     <input type="tel" id="add_phone_number" name="phone_number" placeholder="Contoh: 08123456789" class="input-field w-full px-3 py-2 border border-gray-300 rounded-lg sm:text-sm focus:ring-blue-500 focus:border-blue-500">
                     <span id="add_phone_number-error" class="text-red-500 text-xs mt-1"></span>
                 </div>
                 <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                     <div>
                         <label for="add_password" class="block text-sm font-medium text-gray-700 mb-1">Password <span class="text-red-500">*</span></label>
                         <input type="password" id="add_password" name="password" required minlength="6" placeholder="Minimal 6 karakter" class="input-field w-full px-3 py-2 border border-gray-300 rounded-lg sm:text-sm focus:ring-blue-500 focus:border-blue-500">
                         <span id="add_password-error" class="text-red-500 text-xs mt-1"></span>
                     </div>
                      <div>
                         <label for="add_balance" class="block text-sm font-medium text-gray-700 mb-1">Saldo Awal</label>
                         <input type="number" step="0.01" id="add_balance" name="balance" value="0" class="input-field w-full px-3 py-2 border border-gray-300 rounded-lg sm:text-sm focus:ring-blue-500 focus:border-blue-500">
                         <span id="add_balance-error" class="text-red-500 text-xs mt-1"></span>
                     </div>
                 </div>
                 <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                     <div>
                         <label for="add_role" class="block text-sm font-medium text-gray-700 mb-1">Peran <span class="text-red-500">*</span></label>
                         <select id="add_role" name="role" required class="input-field w-full px-3 py-2 border border-gray-300 rounded-lg sm:text-sm bg-white focus:ring-blue-500 focus:border-blue-500">
                             <option value="member" selected>Member</option>
                             <option value="admin">Admin</option>
                         </select>
                         <span id="add_role-error" class="text-red-500 text-xs mt-1"></span>
                     </div>
                     <div>
                         <label for="add_status" class="block text-sm font-medium text-gray-700 mb-1">Status <span class="text-red-500">*</span></label>
                         <select id="add_status" name="status" required class="input-field w-full px-3 py-2 border border-gray-300 rounded-lg sm:text-sm bg-white focus:ring-blue-500 focus:border-blue-500">
                             <option value="active" selected>Aktif</option>
                             <option value="inactive">Nonaktif</option>
                             <option value="banned">Diblokir</option>
                         </select>
                         <span id="add_status-error" class="text-red-500 text-xs mt-1"></span>
                     </div>
                 </div>
                 <div id="add-user-message" class="text-sm"></div>
             </form>
             <div class="flex items-center justify-end p-6 space-x-2 border-t border-gray-200 rounded-b">
                 <button id="cancel-add-user-button" type="button" class="px-5 py-2.5 text-sm font-medium text-gray-500 bg-white rounded-lg border border-gray-200 hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-gray-200">Batal</button>
                 <button id="save-add-user-button" type="submit" form="add-user-form" class="px-5 py-2.5 text-sm font-medium text-white bg-green-600 hover:bg-green-700 rounded-lg focus:outline-none focus:ring-2 focus:ring-green-500">
                     <i class="fas fa-plus mr-2"></i> Tambah Pengguna
                 </button>
             </div>
         </div>
     </div>

    <div id="delete-user-confirm-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-60 transition-opacity duration-300 ease-in-out" aria-labelledby="delete-user-confirm-modal-title" role="dialog" aria-modal="true">
         <div class="relative bg-white rounded-lg shadow-xl w-full max-w-md mx-4 transform transition-all duration-300 ease-in-out scale-95 opacity-0" id="delete-user-confirm-modal-content">
             <div class="flex items-center justify-between p-5 border-b rounded-t">
                 <h3 id="delete-user-confirm-modal-title" class="text-xl font-semibold text-gray-900 flex items-center">
                    <i class="fas fa-exclamation-triangle text-red-500 mr-3"></i> Konfirmasi Hapus
                 </h3>
                 <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center close-confirm-delete-btn">
                     <i class="fas fa-times text-xl"></i><span class="sr-only">Tutup</span>
                 </button>
             </div>
             <div class="p-6 text-center">
                 <i class="fas fa-trash-alt text-4xl text-red-400 mb-4"></i>
                 <p id="delete-user-confirm-modal-message" class="mb-5 text-lg font-normal text-gray-600">Apakah Anda yakin ingin menghapus pengguna ini?</p>
                 <button type="button" class="text-white bg-red-600 hover:bg-red-800 focus:ring-4 focus:outline-none focus:ring-red-300 font-medium rounded-lg text-sm inline-flex items-center px-5 py-2.5 text-center mr-2" id="confirm-delete-user-btn">
                     Ya, Hapus
                 </button>
                 <button type="button" class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-gray-200 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2.5 hover:text-gray-900 focus:z-10 close-confirm-delete-btn">
                     Batal
                 </button>
             </div>
         </div>
     </div>

    <div id="login-as-confirm-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-60 transition-opacity duration-300 ease-in-out" aria-labelledby="login-as-confirm-modal-title" role="dialog" aria-modal="true">
         <div class="relative bg-white rounded-lg shadow-xl w-full max-w-md mx-4 transform transition-all duration-300 ease-in-out scale-95 opacity-0" id="login-as-confirm-modal-content">
             <div class="flex items-center justify-between p-5 border-b rounded-t">
                 <h3 id="login-as-confirm-modal-title" class="text-xl font-semibold text-gray-900 flex items-center">
                    <i class="fas fa-user-secret text-blue-500 mr-3"></i> Konfirmasi Login Sebagai
                 </h3>
                 <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center close-login-as-btn">
                     <i class="fas fa-times text-xl"></i><span class="sr-only">Tutup</span>
                 </button>
             </div>
             <div class="p-6 text-center">
                 <i class="fas fa-sign-in-alt text-4xl text-blue-400 mb-4"></i>
                 <p id="login-as-confirm-modal-message" class="mb-5 text-lg font-normal text-gray-600">Anda akan login sebagai pengguna ini.</p>
                 <button type="button" class="text-white bg-blue-600 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm inline-flex items-center px-5 py-2.5 text-center mr-2" id="confirm-login-as-btn">
                     Ya, Lanjutkan
                 </button>
                 <button type="button" class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-gray-200 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2.5 hover:text-gray-900 focus:z-10 close-login-as-btn">
                     Batal
                 </button>
             </div>
         </div>
     </div>

</main>
