<?php
    $pageTitle = 'Kelola Tiket Dukungan';
    if (!Auth::isLoggedIn() || $_SESSION['user_role'] !== 'admin') { redirect(base_url('login')); }

    $initialStatusFilter = $_GET['status'] ?? 'all';
    $initialSearchQuery = $_GET['search'] ?? '';
    $initialLimit = $_GET['limit'] ?? 15;
    $initialUserId = $_GET['user_id'] ?? '';

    $statusOptionsAdminTickets = [
        'all' => 'Semua Status',
        'open' => 'Terbuka',
        'answered' => 'Dijawab Admin',
        'user_reply' => 'Balasan Pengguna',
        'closed' => 'Ditutup'
    ];

    $searchColumnOptionsAdminTickets = [
        't.ticket_id' => 'ID Tiket',
        't.subject' => 'Subjek',
        'u.username' => 'Username Pengguna',
        't.user_id' => 'ID Pengguna'
    ];

    $sortColumnOptionsAdminTickets = [
        't.updated_at' => 'Update Terakhir',
        't.created_at' => 'Tanggal Dibuat',
        't.ticket_id' => 'ID Tiket',
        't.subject' => 'Subjek',
        'u.username' => 'Username',
        't.status' => 'Status'
    ];

    $sortTypeOptionsAdminTickets = ['DESC' => 'Terbaru', 'ASC' => 'Terlama'];

    ?>
    <main class="flex-1 overflow-x-hidden overflow-y-auto p-6 md:p-8">
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
            <h2 class="text-2xl font-semibold text-gray-700 flex items-center">
                <i class="fas fa-life-ring mr-3 text-orange-500"></i> Kelola Tiket Dukungan
            </h2>
            <div class="flex items-center space-x-2">
                <button type="button" id="admin-ticket-filter-modal-button"
                        class="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg shadow-sm hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition">
                    <i class="fas fa-filter mr-1"></i> Filter Tiket
                </button>
                </div>
        </div>

        <div id="admin-tickets-message" class="mb-4 text-sm"></div>

        <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID Tiket</th>
                            <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Pengguna</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Subjek</th>
                            <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                            <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Belum Dibaca</th>
                            <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Update Terakhir</th>
                            <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                        </tr>
                    </thead>
                    <tbody id="admin-tickets-table-body" class="bg-white divide-y divide-gray-200">
                        <tr>
                            <td colspan="7" class="px-6 py-10 text-center text-sm text-gray-500 italic">
                                <i class="fas fa-spinner fa-spin mr-2"></i> Memuat daftar tiket...
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div id="admin-tickets-pagination-container" class="px-4 py-3 border-t border-gray-200 bg-gray-50 text-xs text-gray-600 flex flex-col sm:flex-row justify-between items-center">
                <div id="admin-tickets-pagination-info">Menampilkan 0 hasil.</div>
                <div id="admin-tickets-pagination-controls" class="flex justify-end mt-2 sm:mt-0 space-x-1"></div>
            </div>
        </div>

        <div id="admin-ticket-filter-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-60 transition-opacity duration-300 ease-in-out" aria-labelledby="admin-ticket-filter-modal-title" role="dialog" aria-modal="true">
            <div class="relative bg-gray-800 rounded-lg shadow-xl w-full max-w-2xl mx-4 transform transition-all duration-300 ease-in-out scale-95 opacity-0" id="admin-ticket-filter-modal-content">
                <div class="flex items-center justify-between px-6 py-4 border-b border-gray-700">
                    <h3 class="text-lg font-semibold text-gray-100 flex items-center" id="admin-ticket-filter-modal-title">
                        <i class="fas fa-filter mr-2 text-blue-400"></i> Filter Tiket
                    </h3>
                    <button type="button" id="close-admin-ticket-filter-modal" class="text-gray-400 hover:text-white focus:outline-none">
                        <span class="sr-only">Tutup</span><i class="fas fa-times text-xl"></i>
                    </button>
                </div>
                <form id="admin-ticket-filter-form" class="p-6 space-y-4">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="filter_limit_admin_ticket" class="block text-sm font-medium text-gray-300 mb-1">Tampilkan</label>
                            <select id="filter_limit_admin_ticket" name="limit" class="admin-ticket-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <option value="15" <?php echo ($initialLimit == 15) ? 'selected' : ''; ?>>15 baris</option>
                                <option value="30" <?php echo ($initialLimit == 30) ? 'selected' : ''; ?>>30 baris</option>
                                <option value="50" <?php echo ($initialLimit == 50) ? 'selected' : ''; ?>>50 baris</option>
                                <option value="100" <?php echo ($initialLimit == 100) ? 'selected' : ''; ?>>100 baris</option>
                            </select>
                        </div>
                        <div>
                            <label for="filter_status_admin_ticket" class="block text-sm font-medium text-gray-300 mb-1">Status</label>
                            <select id="filter_status_admin_ticket" name="status" class="admin-ticket-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <?php foreach ($statusOptionsAdminTickets as $value => $label): ?>
                                    <option value="<?php echo $value; ?>" <?php echo ($initialStatusFilter === $value) ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                     <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                         <div>
                            <label for="filter_user_id_admin_ticket" class="block text-sm font-medium text-gray-300 mb-1">ID Pengguna</label>
                            <input type="number" id="filter_user_id_admin_ticket" name="user_id" value="<?php echo htmlspecialchars($initialUserId); ?>" placeholder="Kosongkan = Semua"
                                   class="admin-ticket-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label for="filter_unread_admin_ticket" class="block text-sm font-medium text-gray-300 mb-1">Status Baca</label>
                            <select id="filter_unread_admin_ticket" name="unread" class="admin-ticket-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <option value="all" selected>Semua</option>
                                <option value="admin">Belum Dibaca Admin</option>
                            </select>
                        </div>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="filter_search_column_admin_ticket" class="block text-sm font-medium text-gray-300 mb-1">Kolom Cari</label>
                            <select id="filter_search_column_admin_ticket" name="search_column" class="admin-ticket-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <?php foreach ($searchColumnOptionsAdminTickets as $value => $label): ?>
                                    <option value="<?php echo $value; ?>"><?php echo htmlspecialchars($label); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div>
                            <label for="filter_search_keyword_admin_ticket" class="block text-sm font-medium text-gray-300 mb-1">Kata Kunci</label>
                            <input type="text" id="filter_search_keyword_admin_ticket" name="search_keyword" value="<?php echo htmlspecialchars($initialSearchQuery); ?>" placeholder="Masukkan kata kunci..."
                                   class="admin-ticket-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                        </div>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="filter_sort_by_admin_ticket" class="block text-sm font-medium text-gray-300 mb-1">Urutkan</label>
                            <select id="filter_sort_by_admin_ticket" name="sort_by" class="admin-ticket-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <?php foreach ($sortColumnOptionsAdminTickets as $value => $label): ?>
                                    <option value="<?php echo $value; ?>" <?php echo ($value === 't.updated_at') ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div>
                            <label for="filter_sort_type_admin_ticket" class="block text-sm font-medium text-gray-300 mb-1">Tipe</label>
                            <select id="filter_sort_type_admin_ticket" name="sort_type" class="admin-ticket-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <?php foreach ($sortTypeOptionsAdminTickets as $value => $label): ?>
                                    <option value="<?php echo $value; ?>" <?php echo ($value === 'DESC') ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="flex justify-end items-center pt-4 space-x-3 border-t border-gray-700 mt-5">
                        <button type="button" id="reset-admin-ticket-filter-button" class="px-4 py-2 text-sm font-medium text-gray-300 bg-gray-600 rounded-lg hover:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-gray-500 transition">Reset</button>
                        <button type="submit" id="apply-admin-ticket-filter-button" class="px-5 py-2 text-sm font-medium text-white bg-blue-600 rounded-lg shadow hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-blue-500 transition"><i class="fas fa-filter mr-1"></i> Terapkan</button>
                    </div>
                </form>
            </div>
        </div>

    </main>
    